<?php
function get_cluster_number_from_db( $argv ) {
	global $DTASCFG_XML_FILE ;

	/* check number of arguments */
	// if( count( $argv ) != 3 ) {
		// echo "Usage: get_cluster_number_from_db DB_HOST DB_USERNAME DB_PASSWORD\n";
		// exit( 1 ) ;
	// }

	$xml = simplexml_load_file( $DTASCFG_XML_FILE ) ;
    $db_host     = chop( $xml->db->host ) ;
    $db_username = chop( $xml->db->username ) ;
    $db_password = $xml->db->password;
	
	
	$connection = pg_connect( "host=$db_host dbname=dtasdb user=$db_username password=$db_password" ) ;
	if( $connection == false ) {
		echo "ConnectToDbFail: host='$db_host', user='$db_username'" ;
		exit( 1 ) ;
	}

	$record_set = pg_query( "SELECT count(sc_id) FROM tb_sc_info" ) ;
	if( $record_set == false ) {
		echo 'pg_query: ' . pg_last_error();
        pg_close( $connection ) ;
		exit( 1 ) ;
	}

	$result = pg_fetch_row( $record_set ) ;
	if( $result == false ) {
		echo "query result is empty." . "\n" ;
        pg_close( $connection ) ;
		exit( 1 ) ;
	}

    // exclude sc_id 0 and sc_id 1
    // sc_id 0 is just a default value not a cluster
    // sc_id 1 is master sc not a cluster
    $cluster_num = $result[0] - 2;
    
	echo $cluster_num > 0 ? $cluster_num : 0 ;
    pg_close( $connection ) ;
	exit( 0 ) ;
}

